--DROP PROCEDURE App.NVCC_usp_GetXdwUser

USE NWIC_PanelMgmt
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE App.NVCC_usp_GetXdwUser
	-- @username is the network (AD) username/login of the user
	@username varchar(50)
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_GetXdwUser
--Server                : DNS.URL        
--Data Base             : NWIC_PanelMgmt
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 2017-02-14
--
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To get LCustomer and AD information about a user
--==================================================================================
--Uses: CDWWork.NDim.ActiveDirectoryAccount
--Uses: CDWWork.LCustomer.LCustomer
--Uses: CDWWork.Dim.Sta3n

BEGIN
	SELECT TOP 1
		UPPER(ada.SamAccountName) AS NetWorkName
		,ada.Surname AS LastName
		,ada.GivenName AS FirstName
		,lc.LCustomerID
		,AccountEmailAddress as Email
		,lc.UpdatedDate as DateAdded
		,lc.InferredSta3n
		,s.Sta3n AS ADLoginInferredSta3n
	FROM
		CDWWork.NDim.ActiveDirectoryAccount AS ada
		LEFT JOIN CDWWork.LCustomer.LCustomer AS lc
			ON ada.SamAccountName = lc.ADLogin
		LEFT JOIN CDWWork.Dim.Sta3n s
			ON s.SiteCode = SUBSTRING(UPPER(@username), 4, 3)
	WHERE SamAccountName = @username
	ORDER BY lc.UpdatedDate DESC
END
GO

exec sp_SignAppObject 'NVCC_usp_GetXdwUser';

---- Test Cases
---- "Normal" user.
--exec app.NVCC_usp_GetXdwUser 'DNS '
---- 3 character site code not resolvable, no PHI/PII permissions
--exec app.NVCC_usp_GetXdwUser 'DNS '
-- -- No sites, no inferred site
--exec app.NVCC_usp_GetXdwUser 'VA-NSOC-EAS-TESTER1'
---- No inferred site, many (all?) PHIPPI permissions on sites
--exec app.NVCC_usp_GetXdwUser 'PII'
---- No inferred sta3n, VISH, Region, or District, PHIPII pesrmission on 8 sites in VISN 20
--exec app.NVCC_usp_GetXdwUser 'DNS'
---- User who generated a NullReferenceException in User\UserInfo
--exec app.NVCC_usp_GetXdwUser 'DNS'
---- blank
--exec app.NVCC_usp_GetXdwUser ''
---- Non-existant name
--exec app.NVCC_usp_GetXdwUser 'zzzzzzzzzzzzz'
